/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SolitaryNestBlockEntity
extends AdvancedBeehiveBlockEntityAbstract {
    private int nestTickTimer = -1;
    private int spawnCount = 0;

    public SolitaryNestBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.MAX_BEES = 1;
    }

    public SolitaryNestBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModTileEntityTypes.SOLITARY_NEST.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SolitaryNestBlockEntity blockEntity) {
        if (blockEntity.nestTickTimer > 0) {
            Block block = state.m_60734_();
            if (--blockEntity.nestTickTimer <= 0 && blockEntity.canRepopulate() && block instanceof SolitaryNest) {
                Entity newBee = ((SolitaryNest)block).getNestingBeeType(level, (Biome)level.m_204166_(pos).m_203334_());
                if (newBee instanceof Bee) {
                    ((Bee)newBee).m_21153_(((Bee)newBee).m_21233_());
                    ((Bee)newBee).f_27698_ = pos;
                }
                Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                SolitaryNestBlockEntity.spawnBeeInWorldAtPosition((ServerLevel)level, newBee, pos.m_142300_(direction), direction, null);
                blockEntity.nestTickTimer = -1;
            }
            blockEntity.m_6596_();
        }
        AdvancedBeehiveBlockEntityAbstract.tick(level, pos, state, blockEntity);
    }

    public boolean canRepopulate() {
        SolitaryNest nest = (SolitaryNest)this.m_58900_().m_60734_();
        boolean blockConditionsMet = nest.canRepopulateIn(this.f_58857_, (Biome)this.f_58857_.m_204166_(this.m_58899_()).m_203334_());
        return this.m_58774_() && blockConditionsMet;
    }

    public void setNestCooldown(int cooldown) {
        this.nestTickTimer = cooldown;
    }

    public int getNestTickCooldown() {
        return this.nestTickTimer;
    }

    @Override
    protected void beeReleasePostAction(Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        super.beeReleasePostAction(level, beeEntity, state, beeState);
        if (beeEntity.m_20078_() != null && this.spawnCount < (Integer)ProductiveBeesConfig.BEES.cuckooSpawnCount.get() && !beeEntity.m_6162_() && beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED && level.f_46441_.nextFloat() <= 0.1f) {
            Bee offspring;
            switch (beeEntity.m_20078_()) {
                case "productivebees:blue_banded_bee": {
                    Bee bee = (Bee)((EntityType)ModEntities.NEON_CUCKOO_BEE.get()).m_20615_(level);
                    break;
                }
                case "productivebees:ashy_mining_bee": {
                    Bee bee = (Bee)((EntityType)ModEntities.NOMAD_BEE.get()).m_20615_(level);
                    break;
                }
                default: {
                    Bee bee = offspring = null;
                }
            }
            if (offspring != null) {
                ++this.spawnCount;
                offspring.m_146762_(-24000);
                offspring.m_7678_(beeEntity.m_20185_(), beeEntity.m_20186_(), beeEntity.m_20189_(), 0.0f, 0.0f);
                level.m_7967_((Entity)offspring);
            }
        }
        this.nestTickTimer = -1;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        if (tag.m_128441_("nestTickTimer")) {
            this.nestTickTimer = tag.m_128451_("nestTickTimer");
        }
        if (tag.m_128441_("spawnCount")) {
            this.spawnCount = tag.m_128451_("spawnCount");
        }
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        tag.m_128405_("nestTickTimer", this.nestTickTimer);
        tag.m_128405_("spawnCount", this.spawnCount);
    }
}

